#include "tcp.h"

drl(val)	/* define LED register */
int val;
{
	aedbf[0] = DRL;
	aedbf[1] = val;
	obyte(aedbf, 2);
 }

dpk(keyno,icode)		/* define programmable key */
int keyno;
register char icode[];
{
	register char *bp = aedbf,
		      *last =  &(aedbf[10]);

	if( (keyno < 0) || (keyno > 7) ){
		printf(" dsk ** bad key number : %d\n", keyno);
		printf(" key number must be in 0..7\n");
		exit(0);
	}

	*bp++ = DPK;
	*bp++ = keyno;

	while( (bp < last) && (*icode) )
		*bp++ = *icode++;
	if(bp < last)
		*bp++ = 0;
	obyte(aedbf, bp - aedbf);
}

dsk(nkey,nbytes,byte)		/* define soft key */
char byte[];
register int nkey,nbytes;
{

	if( (nkey >=0 ) && (nkey < 8)
	&&  (nbytes > 0) && (nbytes < 16) ){
		aedbf[0] = DSK;
		aedbf[1] = nkey;
		aedbf[2] = nbytes;
		obyte(aedbf,3);
		obyte(byte,nbytes);
		return;
		}
	else{
		printf(" dsk ** invalid arg(s) :\n");
		printf(" key = %d, count = %d\n",nkey, nbytes);
		printf(" must have key in 0..7, count in 1..15\n");
		exit(0);
	}
}
		
scs(byt)	/* set console status */ 
int byt;
{
	aedbf[0] = SCS;
	aedbf[1] = byt;
	obyte(aedbf,2);
}
